% EMB System by Robots5 LLC (USA)
% Spring-Mass-Damper Kit 1DOF - System Response - MATLAB Script. Use with the appropriate SIMULINK File

%% GENERAL PARAMETERS

T = 0.002; % sampling time (change to fit your experiment)
S = 5;   % simulation duration time (change to fit your experiment)

r_theo = 0.01; % pinion gear radius [m], from theory
r_act = 0.0105; % actual pinion gear radius [m], based on force measurement
Kt = 0.0273; % torque constant for the EMB-AM4 actuator [Nm/A], from datasheet

%% PLOTTING - Step System Response - Position

plot(rt_time,cart1_position, 'LineWidth',2)
title('Position vs. Time')
xlabel('Time [s]')
ylabel('Position [m]')
grid on

%% PLOTTING - Step System Response - Velocity

plot(rt_time,cart1_velocity, 'LineWidth',2)
title('Velocity vs. Time')
xlabel('Time [s]')
ylabel('Velocity [m/s]')
grid on

%%